// RadMouse.js //

var Cursor = {}
Cursor.leftIdle = true;
Cursor.rightIdle = true;
Cursor.image = LoadImage("RadLib/Cursor.png");
Cursor.x = 0;
Cursor.y = 0;
Cursor.mapX = 0;
Cursor.mapY = 0;

Cursor.draw = function()
{
	this.x = GetMouseX();
	this.y = GetMouseY();
	if (IsMapEngineRunning())
	{
		this.mapX = ScreenToMapX(0, this.x);
		this.mapY = ScreenToMapY(0, this.y);
	}
	if (this.image != null) this.image.blit(this.x, this.y);
}

Cursor.handleUnPress = function()
{
	if (!IsMouseButtonPressed(MOUSE_RIGHT)) this.rightIdle = true;
	if (!IsMouseButtonPressed(MOUSE_LEFT)) this.leftIdle = true;
}

Cursor.isWithin = function(x, y, w, h)
{
	return (this.x > x && this.y > y && this.x < x+w && this.y < y+h);
}

Cursor.leftClick = function()
{
	this.handleUnPress();
  if (IsMouseButtonPressed(MOUSE_LEFT) && this.leftIdle)
  {
    this.leftIdle = false;
    return true;
  }
  return false;
}
 
Cursor.rightClick = function()
{
  if (IsMouseButtonPressed(MOUSE_RIGHT) && this.rightIdle)
  {
    this.rightIdle = false;
    return true;
  }
  return false;
}

Cursor.setXY = function(x, y)
{
	this.x = x; this.y = y;
	SetMousePosition(x, y);
}

Cursor.setXY(SW/2, SH/2);